

/**
 * Title:        PlacementApplet
 * Description:  Animation of VLSI Module Placement
 * Copyright:    Copyright (c) 2001
 * Company:      Lafayette College
 * @author John Nestor
 * @version 1.0
 */

public class PMoveH extends PMove {
  private int dx;
  public PMoveH(PModule pm) {
    super(pm);
    dx = (int)((Math.random() - 0.5) * genX());
    int newx = moveModule.getX() + dx;
    if (newx < 0)
      dx = -moveModule.getX();
    if (newx > moveModule.getMoveLimit())
      dx = moveModule.getMoveLimit() - moveModule.getX();
    if (dx == 0) {
      if (Math.random() < 0.5) dx = 1;
      else dx = -1;
    }
    deltaCost = moveModule.move(dx,0);
  }

  public String toString() { return moveString("Move-H (" + dx + ")"); }

  public void undo() { super.undo(); moveModule.move(-dx,0); }
}
