
/**
 * Title:        PlacementApplet
 * Description:  Animation of VLSI Module Placement
 * Copyright:    Copyright (c) 2001
 * Company:      Lafayette College
 * @author John Nestor
 * @version 1.0
 */

public class PMoveV extends PMove {
  private int dy;


  public PMoveV(PModule pm) {
    super(pm);
    dy = (int)((Math.random() - 0.5) * genY());
    int newy = moveModule.getY() + dy;
    if (newy < 0)
      dy = -moveModule.getY();
    if (newy > moveModule.getMoveLimit())
      dy = moveModule.getMoveLimit() - moveModule.getY();
    if (dy == 0) {
      if (Math.random() < 0.5) dy = 1;
      else dy = -1;
    }
    deltaCost = moveModule.move(0,dy);
  }

  public void undo() {
    super.undo();
    moveModule.move(0,-dy);
  }

  public String toString() { return moveString("Move-V (" + dy + ")"); }

}
