import java.util.Vector;

/**
 * Title:        PlacementApplet
 * Description:  Animation of VLSI Module Placement
 * Copyright:    Copyright (c) 2001
 * Company:      Lafayette College
 * @author John Nestor
 * @version 1.0
 */

/** tracks history information for a number of cost samples */
public class PTempHistory {

  private double temperature = 0.0;
  private double maxCost = 0;
  private double minCost = Double.MAX_VALUE;
  private double averageCost = 0;
  private double sumCost = 0;
  private int attemptCount = 0;
  private int acceptCount = 0;
  private int rejectCount = 0;
  public Vector samples = new Vector(500);  // contains Doubles 

  public PTempHistory(double t) { temperature = t; }

  public PTempHistory() { this(0.0); }

  public double getTemperature() { return temperature; }

  public double getMaxCost() { return maxCost; }

  public double getMinCost() { return minCost; }

  public double getAverage() { return averageCost; }

  public int getAttemptCount() { return attemptCount; }

  public int getAcceptCount() { return acceptCount; }

  public int getRejectCount() { return rejectCount; }

  public double getAcceptPercent() {
    return (double)acceptCount / (double)(acceptCount + rejectCount) * 100.0;
  }

  public double getStdev() {
    double stdevSum = 0;
    for (int i=0; i<samples.size(); i++ ) {
      Double s = (Double)samples.elementAt(i);
      double diff = s.doubleValue() - averageCost;
      stdevSum += diff * diff;
    }
    return Math.sqrt(stdevSum / (acceptCount-1));
  }


  public void addSample(double sampleCost, boolean accepted) {
    attemptCount++;
    if (accepted) {
      minCost = Math.min(minCost, sampleCost);
      maxCost = Math.max(maxCost, sampleCost);
      sumCost += sampleCost;
      samples.addElement(new Double(sampleCost));
      acceptCount++;
      averageCost = sumCost / acceptCount;
    } else {
      rejectCount++;
    }
  }

}
