import java.awt.FlowLayout;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JLabel;
import javax.swing.JButton;
import javax.swing.BorderFactory;
import java.awt.BorderLayout;
import java.awt.GridLayout;


/**
 * Title:        PlacementApplet
 * Description:  Animation of VLSI Module Placement
 * Copyright:    Copyright (c) 2001
 * Company:      Lafayette College
 * @author John Nestor
 * @version 1.0
 */

public class UILayout extends JPanel {
  JPanel messagePanel;

  public UILayout(PLayout ml) {
    super();
    System.out.println("ULayout constructor");
    myLayout = ml;
    setLayout(new BorderLayout());
    placementPanel = new  UIPlacementPanel(myLayout);
    add(placementPanel,BorderLayout.CENTER);
    placementPanel.setLayout(null);  // absolute positioning!
    //placementPanel.setPreferredSize(200,200);
    placementPanel.setBorder(BorderFactory.createLineBorder(Color.black));
    add(placementPanel,BorderLayout.CENTER);
    statusPanel = new JPanel();
    statusPanel.setLayout(new GridLayout(1,4));
  //  statusPanel.setPreferredSize(new Dimension(200,30));
    areaDisplay = new UIValDisplay("Area",0);
    statusPanel.add(areaDisplay);
    olapDisplay = new UIValDisplay("Overlap",0);
    statusPanel.add(olapDisplay);
    wireDisplay = new UIValDisplay("Wirelength",0);
    statusPanel.add(wireDisplay);
    costDisplay = new UIValDisplay("Cost",0);
    statusPanel.add(costDisplay);
    add(statusPanel,BorderLayout.NORTH);
    messagePanel = new JPanel();
    messageLabel = new JLabel("This Space for Rent");
    messagePanel.add(messageLabel);
    add(messagePanel,BorderLayout.SOUTH);
    addModules();
    myLayout.calcCost();
  }

  private void addModules() {
    for (int i = 0; i < myLayout.numModules(); i++ ) {
      PModule pm = myLayout.getModule(i);
      placementPanel.add(new UIModule(pm));
    }
  }

  public void setMessage(String m) {
    messageLabel.setText(m);
    messagePanel.repaint();
  }

  public void setMoveMessage() {
    PMove lastMove = myLayout.getLastMove();
    if (lastMove != null) setMessage(lastMove.toString());
    else (setMessage(""));
  }

  public void setCostDisplay() {
    areaDisplay.setValue(myLayout.currentArea());
    olapDisplay.setValue(myLayout.currentOverlap());
    wireDisplay.setValue(myLayout.currentWirelength());
    costDisplay.setValue(myLayout.currentCost());
    statusPanel.repaint();
 }

  public void paintComponent(Graphics g) {
    setCostDisplay();
    setMoveMessage();
    super.paintComponent(g);
  }

  /** convert placement coordinate to screen coordinate */
  public static int scale(int i) { return (int)((double)i * zoom); }

  /** convert screen coordinate to placement coordinate */
  public static int unscale(int i) { return (int)((double)(i) / zoom); }

  public static void setZoom(double s) { zoom = s; }
  private static double zoom = 2.0;

  public void autoZoom() {
    System.out.println("autoZoom: panelw =" + placementPanel.getWidth()
                      + " panelh =" + placementPanel.getHeight() +
                        " lb=" + myLayout.currentBottomEdge()
                      + " lr=" + myLayout.currentRightEdge());
    double vscale = 0.9 * (double)placementPanel.getWidth() / (double)myLayout.currentRightEdge();
    double hscale = 0.9 * (double)placementPanel.getHeight() / (double)myLayout.currentBottomEdge();
    zoom = Math.min(vscale,hscale);
    System.out.println("autozoom: zoom = " + zoom);
  }


  private PLayout myLayout;
  private JPanel placementPanel;
  private JPanel statusPanel;
  private UIValDisplay areaDisplay;
  private UIValDisplay olapDisplay;
  private UIValDisplay wireDisplay;
  private UIValDisplay costDisplay;
  private JLabel messageLabel;

  public static void main(String [] args) {
    PLayout test = new PLayout("ntest.in");
    JFrame jf = new JFrame("UILayout Test");
    UILayout uil = new UILayout(test);
    uil.setSize(200,200);
    jf.setSize(300,300);
    jf.getContentPane().add(uil);
    jf.setVisible(true);
    jf.addWindowListener( new WindowAdapter()
      {
	    public void windowClosing(WindowEvent e) { System.exit(0); }
      } );
    uil.autoZoom();
  }
}
