import java.awt.*;
import java.awt.event.*;
import javax.swing.JLabel;
import javax.swing.BorderFactory;
import javax.swing.SwingConstants;

/**
 * Title:        PlacementApplet
 * Description:  Animation of VLSI Module Placement
 * Copyright:    Copyright (c) 2001
 * Company:      Lafayette College
 * @author John Nestor
 * @version 1.0
 */

public class UIModule extends JLabel {

  private static DragListener dragger = new DragListener();

  private PModule myModule;

  public UIModule(PModule mod) {
    addMouseMotionListener(dragger);
    addMouseListener(dragger);
    myModule = mod;
    setBorder(BorderFactory.createLineBorder(Color.black,2));
    setText(mod.getName());
    setBackground(Color.yellow);
    setOpaque(true);
    setHorizontalAlignment(SwingConstants.CENTER);
    // debug
    System.out.println("UIModule:" + mod.getName() + " width= " + mod.width() + " (" + UILayout.scale(mod.width())
             + ") height=" + mod.height() + " (" + UILayout.scale(mod.height()) + ")");
    setSize(UILayout.scale(mod.width()),UILayout.scale(mod.height()));
    super.setLocation( UILayout.scale(mod.getX()), UILayout.scale(mod.getY()) );  // avoid overridden version
  }

  /** update UI location based on PModule object */
  public void updateLocation() {
    setSize(UILayout.scale(myModule.width()),UILayout.scale(myModule.height()));
    super.setLocation( UILayout.scale(myModule.getX()), UILayout.scale(myModule.getY()) );
  }

  public void setLocation(int x, int y) {
    super.setLocation(x,y);
    myModule.setLocation(UILayout.unscale(x),UILayout.unscale(y));
  }

  public void flipHorizontal() {
    System.out.println("flipHorizontal " + getText());
    myModule.flipHorizontal();
    getParent().getParent().repaint();
  }

  public void flipVertical() {
    System.out.println("flipVertical " + getText());
    myModule.flipVertical();
    getParent().getParent().repaint();
  }

  public void rotate() {
    System.out.println("rotate " + getText());
    myModule.rotate();
    getParent().getParent().repaint();
  }

  /* draw the terminals - the module should otherwise draw itself */
  public void paintComponent(Graphics g) {
    updateLocation();
    if (myModule.isMoveModule()) {
      if (myModule.isRejectedMoveModule()) setBackground(Color.red);
      else setBackground(Color.green);
    } else setBackground(Color.yellow);
    super.paintComponent(g);
    for(int i = 0; i < myModule.numTerminals(); i++) {
      PTerminal pt = myModule.getTerminal(i);
      g.setColor(Color.black);
      int tx = Math.max( UILayout.scale(pt.getX())-2, 0);
      int ty = Math.max( UILayout.scale(pt.getY())-2, 0);
      tx = Math.min( tx, UILayout.scale(myModule.width()) - 5 );
      ty = Math.min( ty, UILayout.scale(myModule.height()) - 5 );
      g.fillRect(tx, ty, 5, 5);
    }
  }
}
