import java.awt.Color;
import java.awt.Graphics;
import java.awt.Dimension;

import javax.swing.JPanel;

public class UIPlacementPanel extends JPanel {
  private PLayout myLayout;

  public UIPlacementPanel(PLayout ml) {
    myLayout = ml;
    setLayout(null);
  }

  public void paintComponent(Graphics g) {
    super.paintComponent(g);
    UILayout ul = (UILayout)getParent();
    for (int i=0; i<myLayout.numNets(); i++) {
      PNet pn = myLayout.getNet(i);
      if (pn.numTerminals() <= 1) continue;
      PTerminal ot = pn.getTerminal(0);
      g.setColor(Color.red);
      for (int j=1; j < pn.numTerminals(); j++) {
        PTerminal dt = pn.getTerminal(j);
        g.drawLine( ul.scale(ot.getLayoutX()), ul.scale(ot.getLayoutY()), ul.scale(dt.getLayoutX()), ul.scale(dt.getLayoutY()) );
      }
    }
  }

}