import java.util.Random;

/** Random variate generator to generate pseudorandom numbers with an exponential distribution */
class ExpVariateGenerator {
  /** initialize with an explicit seed */
  public ExpVariateGenerator(double m, long seed) {
    mean = m;
    r = new Random(seed);
  }
  
  /** initialize with seed specified by random class (current time) */  
  public ExpVariateGenerator(double m) { 
    mean = m;
    r = new Random();
  }
  
  /** generate and return the next random variate 
      * @return the next random variate with given mean */
  double nextVariate() {
    return -mean * Math.log(r.nextDouble());
  }
  
  /** used for test code */
  public static int testTrials = 5000;
  
  /** Test code */
  public static void main(String [] args) {
    double r;
    double sum = 0;
    double maxv = 0;
    double minv = 0;
    ExpVariateGenerator evr = new ExpVariateGenerator(5.0);
    r = evr.nextVariate();
    maxv = minv = r;
    sum += r;
    for (int i = 0; i < testTrials-1; i++) {
      r = evr.nextVariate();
      maxv = Math.max(maxv, r);
      minv = Math.min(minv, r);
      sum += r;
    }
    System.out.println("trials: " + testTrials + " average: " +
    	sum/testTrials + " min: " + minv + " max: " + maxv);
  }
    
  
  private double mean;
  private Random r;
}